OPTION AUTORUN ON
OPTION EXPLICIT
OPTION BASE 0

CONST RELAYCOUNT=20
DIM BUFF(1024) AS INTEGER	
DIM K AS STRING
DIM MMIP AS STRING
DIM RELAYNAMES(RELAYCOUNT) AS STRING
DIM RELAYIP(RELAYCOUNT) AS STRING
DIM IPOCTETS(4) AS INTEGER
DIM GETREQ AS STRING
DIM OPENREQ AS STRING
DIM CLOSEREQ AS STRING
DIM SCANIP AS STRING
DIM RELAYTAG AS STRING
DIM HOST AS STRING
DIM CURRENTRELAY AS INTEGER
DIM OKRESULT AS STRING

DO WHILE MM.INFO(IP ADDRESS) = "0.0.0.0"
	IF TIMER > 5000 THEN
		PRINT "ENSURE YOU HAVE A WIFI NETWORK CONFIGURED"
		PRINT "OPTION WIFI ";CHR$(34);"SSID";CHR$(34);",";CHR$(34);"PASSWORD"
		PRINT "RESTARTING"
		PAUSE 100
		CPU RESTART
	ENDIF
LOOP

VAR RESTORE
MMIP=MM.INFO(IP ADDRESS)
GETOCTETS
PRINT "WEBMITE'S IP IS ";GETIPSTRING()
GETREQ = "GET / HTTP/1"+CHR$(13)+CHR$(10)+CHR$(13)+CHR$(10)
OPENREQ = "GET /open HTTP/1"+CHR$(13)+CHR$(10)+CHR$(13)+CHR$(10)
CLOSEREQ = "GET /close HTTP/1"+CHR$(13)+CHR$(10)+CHR$(13)+CHR$(10)
RELAYTAG="MDNS:relay."
OKRESULT="200 OK"
CURRENTRELAY=-1

LISTRELAYS
DOHELP
'MAIN LOOP
DO
	K=INKEY$
	IF K="?" THEN DOHELP
	IF K="~" THEN CPU RESTART
	IF K="V" OR K="v" THEN CHECKIP
	IF K="X" OR K="x" THEN
		IF CURRENTRELAY>=0 AND CURRENTRELAY<RELAYCOUNT THEN
			RELAYNAMES(CURRENTRELAY)=""
			RELAYIP(CURRENTRELAY)=""
			VAR SAVE RELAYNAMES(),RELAYIP()
			PRINT "RELAY ";CHR$(65+CURRENTRELAY);" DELETED."
			CURRENTRELAY=-1
		ELSE
			PRINT "CHOOSE A RELAY, THEN TRY DELETING AGAIN."
		ENDIF
	ENDIF
	IF K="Y" OR K="y" THEN DOSCAN	
	IF K="Z" OR K="z" THEN LISTRELAYS
	IF ASC(K)>= 65 and ASC(K)< (65+RELAYCOUNT) THEN 	''UPPER CASE
		CURRENTRELAY=ASC(K)-65
		PRINT "ACTIVE RELAY IS ";CHR$(65+CURRENTRELAY)
	ENDIF
	IF ASC(K)>= 97 and ASC(K)< (97+RELAYCOUNT) THEN 	''LOWER CASE
		CURRENTRELAY=ASC(K)-97
		PRINT "ACTIVE RELAY IS ";CHR$(65+CURRENTRELAY)
	ENDIF
	IF K="0" OR K="1" THEN SETRELAY
LOOP

SUB MAKEREQ(HTTPIP AS STRING, URL AS STRING)
	LOCAL INTEGER J
	'PRINT "ACCESSING:";HTTPIP;",";URL
	ON ERROR IGNORE
	WEB OPEN TCP CLIENT HTTPIP,80
	IF	MM.ERRNO<>0 THEN					'retry on fail
		WEB CLOSE TCP CLIENT
		PAUSE 100
		WEB OPEN TCP CLIENT HTTPIP,80
	ENDIF
	IF MM.ERRNO=0 THEN
		'PRINT "REQUESTING"
		WEB TCP CLIENT REQUEST URL, BUFF() ,5000
		PAUSE 500	''let all data come in
		WEB CLOSE TCP CLIENT
		J=LINSTR(BUFF(),OKRESULT)
		'PRINT "LENGTH:";LLEN(BUFF());" J=";J
		IF J>0 THEN 
			PRINT "REQUEST SUCCESS"
		ELSE
			PRINT "REQUEST FAILED"
		ENDIF
		'LONGSTRING PRINT BUFF()
		LONGSTRING CLEAR BUFF() 
		'PRINT MM.ERRMSG$;MM.ERRNO
	ELSE
		PRINT "REQUEST FAILED"
		'PRINT MM.ERRMSG$;MM.ERRNO
	ENDIF
	WEB CLOSE TCP CLIENT
	PAUSE 1000
	ON ERROR CLEAR
	ON ERROR ABORT
END SUB

SUB SETRELAY
	IF CURRENTRELAY>=0 AND CURRENTRELAY<RELAYCOUNT THEN
		PRINT "CLOSING ";CHR$(65+CURRENTRELAY)
		IF RELAYNAMES(CURRENTRELAY)="" OR RELAYIP(CURRENTRELAY)="" THEN
			PRINT "CHOOSE A RELAY, THEN TRY AGAIN."
		ELSE
			IF K="0" THEN
				MAKEREQ(RELAYIP(CURRENTRELAY),OPENREQ)
			ELSE
				MAKEREQ(RELAYIP(CURRENTRELAY),CLOSEREQ)
			ENDIF
		ENDIF
	ELSE
		PRINT "CHOOSE A RELAY, THEN TRY AGAIN."
	ENDIF
END SUB

SUB DOHELP
	PRINT
	PRINT "~ TO REBOOT"
	PRINT "? FOR THIS HELP"
	PRINT "A...";CHR$(64+RELAYCOUNT);" TO SET ACTIVE RELAY"
	PRINT "V TO CHECK A SINGLE IP"
	PRINT "X TO DELETE ACTIVE RELAY"
	PRINT "Y TO SCAN, COULD TAKE A WHILE"
	PRINT "Z TO LIST RELAYS"
	PRINT "TYPE 0 OR 1 TO CONTROL RELAY"
	PRINT
END SUB

SUB LISTRELAYS
	LOCAL INTEGER I
	LOCAL INTEGER J
	J=0
	FOR I = 0 TO RELAYCOUNT-1
		IF RELAYNAMES(I)<>"" THEN J=J+1
	NEXT I
	PRINT J;" RELAYS SAVED"
	FOR I = 0 TO RELAYCOUNT-1
		IF RELAYNAMES(I)<>"" THEN
			PRINT "RELAY ";CHR$(65+I);" (";RELAYNAMES(I)") AT ";RELAYIP(I)
		ENDIF
	NEXT I
END SUB

SUB CHECKADD
	LOCAL INTEGER I
	IF HOST = "" THEN EXIT SUB
	FOR I = 0 TO RELAYCOUNT-1
		IF RELAYNAMES(I)=HOST THEN
			IF RELAYIP(I) = SCANIP THEN
				PRINT "RELAY ";CHR$(65+I);" (";RELAYNAMES(I)") ALREADY AT ";RELAYIP(I)
				EXIT SUB
			ELSE
				RELAYIP(I)=SCANIP
				VAR SAVE RELAYNAMES(),RELAYIP()
				PRINT "RELAY ";CHR$(65+I);" (";RELAYNAMES(I)") UPDATED TO ";RELAYIP(I)
				EXIT SUB
			ENDIF
		ENDIF
	NEXT I
	FOR I = 0 TO RELAYCOUNT-1
		IF RELAYNAMES(I)="" THEN
			RELAYNAMES(I)=HOST
			RELAYIP(I)=SCANIP
			VAR SAVE RELAYNAMES(),RELAYIP()
			PRINT "RELAY ";CHR$(65+I);" (";RELAYNAMES(I)") ADDED AT ";RELAYIP(I)
			EXIT SUB
		ENDIF	
	NEXT I
END SUB

SUB CHECKIP
	LOCAL INTEGER I
	LOCAL STRING K
	LOCAL INTEGER C
	I=0
	K=""
	PRINT "ENTER LAST OCTET OF IP:";
	DO WHILE K<> CHR$(13)
		K=INKEY$
		PRINT K;
		C=ASC(K)-48
		IF C>=0 AND C<=9 THEN I=I*10+C
	LOOP
	PRINT	'next line
	HOST=""
	IPOCTETS(3)=I
	SCANIP=GETIPSTRING()
	PRINT SCANIP
	SCANSINGLE
	DOHELP
END SUB

SUB SCANSINGLE
	LOCAL INTEGER J
	SCANIP=GETIPSTRING()
	'PRINT SCANIP
	ON ERROR IGNORE
	WEB OPEN TCP CLIENT SCANIP,80
	IF	MM.ERRNO<>0 THEN					'retry on fail
		WEB CLOSE TCP CLIENT
		PAUSE 100
		WEB OPEN TCP CLIENT SCANIP,80
	ENDIF
	IF MM.ERRNO=0 THEN
		'PRINT "REQUESTING"
		WEB TCP CLIENT REQUEST GETREQ, BUFF() ,5000
		PAUSE 500	''let all data come in
		WEB CLOSE TCP CLIENT
		J=LINSTR(BUFF(),RELAYTAG)
		'PRINT "LENGTH:";LLEN(BUFF());" J=";J
		IF J>0 THEN HOST=LGETSTR$(BUFF(),J+5,24)
		'LONGSTRING PRINT BUFF()
		LONGSTRING CLEAR BUFF() 
		'PRINT MM.ERRMSG$;MM.ERRNO
	ELSE
		'PRINT "NO HTTP SERVER"
		'PRINT MM.ERRMSG$;MM.ERRNO
	ENDIF
	WEB CLOSE TCP CLIENT
	PAUSE 1000
	ON ERROR CLEAR
	ON ERROR ABORT
	IF LEN(HOST)>0 THEN
		PRINT HOST;" AT ";SCANIP
		CHECKADD
	ELSE
		PRINT SCANIP;" SCANNED"
	ENDIF
END SUB

SUB DOSCAN
	LOCAL INTEGER I
	LOCAL INTEGER J
	PRINT "SCANNING"
	PRINT "PRESS SPACE TO ABORT"
	FOR I = 1 TO 254	'should be in this range
		HOST=""
		IPOCTETS(3)=I
		SCANSINGLE
		IF INKEY$=" " THEN PRINT "ABORT":EXIT SUB
	NEXT I
	PRINT "SCAN DONE, REBOOTING"
	PAUSE 100
	CPU RESTART
END SUB

SUB GETOCTETS
	LOCAL INTEGER P,I,C 
	P=0
	IPOCTETS(0)=0
	IPOCTETS(1)=0
	IPOCTETS(2)=0
	IPOCTETS(3)=0
	FOR I = 1 TO LEN(MMIP)
		C=ASC(MID$(MMIP,I,1))
		IF C=ASC(".") THEN P=P+1
		C=C-48
		IF C>=0 AND C<=9 THEN
			IF P < 4 THEN
				IPOCTETS(P)=IPOCTETS(P)*10+C
			ENDIF
		ENDIF
	NEXT I
END SUB

FUNCTION GETIPSTRING() AS STRING
	GETIPSTRING=STR$(IPOCTETS(0))+"."+STR$(IPOCTETS(1))+"."+STR$(IPOCTETS(2))+"."+STR$(IPOCTETS(3))
END FUNCTION
